import { StyleSheet, Text, View, TextInput, Pressable, TouchableOpacity } from "react-native";
import React, {useState} from "react";
import BackNavigation from "../../Utilities/CustomHeader/BackNavigation";
import useLangTranslation from "../../../hooks/useLangTranslation";
import { settingStyle } from "./SettingStyle";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";
import CustomSVG from "../../../src/components/CustomSVG/CustomSVG";
import AlertIcon from "../../../assets/svgs/alert.svg"
import { EditProfileStyle } from "../EditProfile/StyleEditProfile";
import { addNewAddressStyle } from "../Address/AddNewAddress/AddNewAddressStyle";
import CustomSpinner from "../../Utilities/CustomSpinner/CustomSpinner";
import { BASE_API_URL_STG } from "@env";
import useAuth from "../../../hooks/useAuth";
import { useDispatch, useSelector } from "react-redux";
import { deleteUser, resetState, setError } from "../../../redux/slices/user/deleteUser/deleteUser";
import { loginStyles } from "../../../components/Authentication/Login/LoginStyle";
import { logout } from "../../../redux/slices/auth/signIn";
import { useNavigation } from "@react-navigation/native";

const DeleteAccount = () => {
    const {trans} = useLangTranslation();
    const {access_token} = useAuth();
    const dispatch = useDispatch();
    const navigation = useNavigation();

    const [password, setPassword] = useState('');
    const {data, error, isLoading, isError} = useSelector(state => state.deleteUser);

    const handleChangePassword = async () => {
        dispatch(resetState());
        if(!password) {
            dispatch(setError(trans('Password is required')));
            return;
        }
        const url = `${BASE_API_URL_STG}/user/account/delete?password=${password}`;
        const res = await dispatch(deleteUser({url, access_token}));
        const {code} = res?.payload?.status || {};
        if(code == 200) {
            dispatch(logout());
            navigation.navigate('DrawerStack')
        }
    }
    return (
        <View style={{flex: 1}}>
            <BackNavigation
                navigationProps={navigation}
                routeName={trans("Delete Account")}
                capitalize={true}
            />
            <View style={settingStyle.hrLine} />
            <View style={styles.cont}>
                <View style={styles.titleCont}>
                    <CustomSVG
                        svgIcon={AlertIcon}
                        isRtl={1}
                        height={dpr(56)}
                        width={dpr(56)}
                    />
                    <Text style={styles.title}>
                        {trans('Are you sure you want to delete this account?')}
                    </Text>
                </View>
                <Text style={styles.desc}>
                    {trans('Once deleted, every information and files will be lost forever.')}
                </Text>
                <View>
                    <Text style={EditProfileStyle.label}>
                        {trans("Enter password to delete your account.")}
                    </Text>
                    <TextInput
                        value={password}
                        placeholder={trans("Password")}
                        style={EditProfileStyle.textInput}
                        onChangeText={(text) => setPassword(text)}
                    />
                    {isError && <Text style={loginStyles.noteText}>{error}</Text>}
                </View>
            </View>
            <View style={[EditProfileStyle.changeInfo, styles.footer]}>
                <TouchableOpacity
                    onPress={() => navigation.goBack()}
                >
                    <Text style={EditProfileStyle.cancel}>
                        {trans("Cancel")}
                    </Text>
                </TouchableOpacity>
                <Pressable
                    onPress={handleChangePassword}
                >
                    <View style={[addNewAddressStyle.saveAddressCont, styles.deleteBtn]}>
                        {isLoading ? (
                            <CustomSpinner
                                filePath={require("../../../assets/lottie/loader3.json")}
                                size={{
                                    width: dpr(60),
                                    height: dpr(50),
                                }}
                            />
                        ) : (
                            <Text
                                style={[addNewAddressStyle.saveAddressBtn, styles.deleteText]}
                            >
                                {trans("Delete Account")}
                            </Text>
                        )}
                    </View>
                </Pressable>
            </View>
        </View>
    );
};

export default DeleteAccount;

const styles = StyleSheet.create({
    cont: {
        paddingHorizontal: dpr(20),
        marginTop: dpr(28)
    },
    titleCont: {
        flexDirection: 'row',
        alignItems: 'center'
    },
    title: {
        color: '#2C2C2C',
        fontFamily: 'DMSans_500Medium',
        fontSize: dpr(18),
        lineHeight: 22,
        marginLeft: dpr(16),
        width: dpr('wf') - dpr(40+56+16+40)
    },
    desc: {
        color: '#898989',
        fontFamily: 'Roboto_500Medium',
        fontSize: dpr(16),
        lineHeight: 22,
        marginTop: dpr(18)
    },
    footer: {
        position: 'absolute',
        left: 0,
        right: 0,
        bottom: 0
    },
    deleteBtn: {
        backgroundColor: '#C8191C'
    },
    deleteText: {
        color: '#FFFFFF'
    },
});
